/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.reference.adapters
{
    using System;
    using org.owasp.appsensor;
    using Owasp.Esapi;
    using Owasp.Esapi.Interfaces;

    /**
     * This is a simple adapter class.  All it does is implement the ASLogger interface
     * and call through to get the logger from Esapi in order to pass through
     * the method requests.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since May 6, 2010
     */
    public class ESAPIASLogger : ASLogger
    {

        /**
         * Serial Version UID for serialization
         */
        private const long serialVersionUID = -2439788071519581531L;

        private ILogger esapiLogger;

        /**
         * Constructor that initializes logger
         * @param className The module to associate the logger with.
         */
        public ESAPIASLogger(String className)
        {
            esapiLogger = Esapi.GetLogger(className);
        }

        /**
         * {@inheritDoc}
         */
        public void Debug(String message)
        {
            esapiLogger.Debug(LogEventTypes.SECURITY, message);
        }

        /**
         * {@inheritDoc}
         */
        public void Debug(String message, Exception throwable)
        {
            esapiLogger.Debug(LogEventTypes.SECURITY, message, throwable);
        }

        /**
         * {@inheritDoc}
         */
        public void Error(String message)
        {
            esapiLogger.LogError(LogEventTypes.SECURITY, message);
        }

        /**
         * {@inheritDoc}
         */
        public void Error(String message, Exception throwable)
        {
            esapiLogger.LogError(LogEventTypes.SECURITY, message, throwable);
        }

        /**
         * {@inheritDoc}
         */
        public void Fatal(String message)
        {
            esapiLogger.Fatal(LogEventTypes.SECURITY, message);
        }

        /**
         * {@inheritDoc}
         */
        public void Fatal(String message, Exception throwable)
        {
            esapiLogger.Fatal(LogEventTypes.SECURITY, message, throwable);
        }

        /**
         * {@inheritDoc}
         */
        public void Info(String message)
        {
            esapiLogger.Info(LogEventTypes.SECURITY, message);
        }

        /**
         * {@inheritDoc}
         */
        public void Info(String message, Exception throwable)
        {
            esapiLogger.Info(LogEventTypes.SECURITY, message, throwable);
        }

        /**
         * {@inheritDoc}
         */
        public void Warning(String message)
        {
            esapiLogger.Warning(LogEventTypes.SECURITY, message);
        }

        /**
         * {@inheritDoc}
         */
        public void Warning(String message, Exception throwable)
        {
            esapiLogger.Warning(LogEventTypes.SECURITY, message, throwable);
        }
    }
}